﻿using System;
using System.Runtime.InteropServices;

namespace Synexens
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYDeviceInfo
    {
        public uint m_nDeviceID;

        public SYDeviceType m_deviceType;

        public uint m_nUsbBus;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public uint[] m_nUsbPorts;

        public uint m_nUsbPortsNumber;

        public uint m_nUsbDeviceAddress;

        public uint m_nIPAddress;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYEventInfo
    {
        public SYEventType m_eventType;

        public IntPtr m_pEventInfo;

        public int m_nLength;
    };

    [StructLayout(LayoutKind.Sequential,Pack = 1)]
    public struct SYFrameInfo
    {
        public SYFrameType m_frameType;

        public int m_nFrameHeight;

        public int m_nFrameWidth;
    }

    [StructLayout(LayoutKind.Sequential,Pack = 1)]
    public struct SYFrameData
    {
        public int m_nFrameCount;

        public IntPtr m_pFrameInfo;

        public IntPtr m_pData;

        public int m_nBuffferLength;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYPointCloudData
    {
        public float m_fltX;

        public float m_fltY;

        public float m_fltZ;
    };
    
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYIntrinsics
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
        public float[] m_fltFOV;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 5)]
        public float[] m_fltCoeffs;

        public float m_fltFocalDistanceX;

        public float m_fltFocalDistanceY;

        public float m_fltCenterPointX;

        public float m_fltCenterPointY;

        public int m_nWidth;

        public int m_nHeight;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public float[] m_fltTOF2RGBRotate;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public float[] m_fltTOF2RGBTranslation;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYAIModelInfo
    {
        public SYAIModelType m_modelType;

        public float m_fltNMS;

        public float m_fltBox;

        public IntPtr m_pFileData;

        public int m_nFileLength;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct BOX_RECT
    {
        public int left;

        public int right;

        public int top;
        
        public int bottom;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct detect_result_t
    {
        public int id;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string name;

        public BOX_RECT box;

        public float prop;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct detect_result_group_t
    {
        public int id;

        public int count;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public detect_result_t results;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYFilterParam
    {
        public SYFilterType m_FilterType;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
        public float m_paramValue;

        public int m_nParamCount;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYConfiguration
    {
        public SYStreamType m_streamType;

        public SYResolution m_resolutionDepth;

        public SYResolution m_resolutionRGB;

        public int m_nFrameRate;

        public int m_nIntegralTime;

        public bool m_bMirror;

        public bool m_bFlip;

        public bool m_bFilter;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
        public SYFilterParam m_filterParam;
        
        public int m_nFilterCount;
    }
}