﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using OpenCvSharp;
using Synexens;
using System.Threading;
namespace SDKTest
{
    public static class SYProgram
    {
        private static Dictionary<uint, Synexens.SYStreamType> g_mapStreamType = new Dictionary<uint, Synexens.SYStreamType>();
        private static Dictionary<uint, bool> g_mapSavePCL = new Dictionary<uint, bool>();
        private static Dictionary<uint, bool> g_mapSaveDepthOrRAW = new Dictionary<uint, bool>();
  
        private static Point curMousePoint = new Point(-1, -1);
        
        public static void on_mouse(MouseEventTypes @event, int x, int y, MouseEventFlags flags, IntPtr userData)
        {
            if (@event == MouseEventTypes.LButtonDown || (@event == MouseEventTypes.MouseMove && (flags == MouseEventFlags.LButton)))
            {
                Console.WriteLine($"x:{x} y:{y}");
                curMousePoint = new Point(x, y);
            }
            else if (flags == MouseEventFlags.LButton)
            {
                curMousePoint = new Point(-1, -1);
            }
        }
        
        public static void CreateOpencvWindow(uint nDeviceID, SYStreamType streamType, bool bDestroyOld = false)
        {
            string name;
            switch (streamType)
            {
            case SYStreamType.SYSTREAMTYPE_NULL:
                break;
            case SYStreamType.SYSTREAMTYPE_RAW:
                if (bDestroyOld)
                {
                    name = $"RGBD_depth_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                    name = $"RGBD_RGB_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"raw_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_DEPTH:
                if (bDestroyOld)
                {
                    name = $"raw_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"depth_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_RGB:
                if (bDestroyOld)
                {
                    name = $"depth_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"RGB_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_DEPTHIR:
                if (bDestroyOld)
                {
                    name = $"RGB_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"depth_{nDeviceID}";
                Cv2.NamedWindow(name);
                name = $"ir_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_DEPTHRGB:
                if (bDestroyOld)
                {
                    name = $"ir_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"depth_{nDeviceID}";
                Cv2.NamedWindow(name);
                name = $"RGB_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_DEPTHIRRGB:
                name = $"depth_{nDeviceID}";
                Cv2.NamedWindow(name);
                name = $"ir_{nDeviceID}";
                Cv2.NamedWindow(name);
                name = $"RGB_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            case SYStreamType.SYSTREAMTYPE_RGBD:
                if (bDestroyOld)
                {
                    name = $"depth_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                    name = $"ir_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                    name = $"RGB_{nDeviceID}";
                    Cv2.DestroyWindow(name);
                }
                name = $"RGBD_depth_{nDeviceID}";
                Cv2.NamedWindow(name);
                name = $"RGBD_RGB_{nDeviceID}";
                Cv2.NamedWindow(name);
                break;
            default:
                break;
            }
        }
        
        public static void IsImgWindow(string windowName, Mat imgData)
        {
            Cv2.ImShow(windowName,imgData);
        }
        
        public static unsafe void ProcessFrameData(uint nDeviceID, IntPtr pFrameData)
        {
            if (!g_mapStreamType.ContainsKey(nDeviceID))
            {
                return;
            }
            
            if (g_mapStreamType.TryGetValue(nDeviceID, out Synexens.SYStreamType streamType))
            {
                if (streamType == SYStreamType.SYSTREAMTYPE_RGBD)
                {
                    Dictionary<SYFrameType, int> mapIndex = new Dictionary<SYFrameType, int>();
                    Dictionary<SYFrameType, int> mapPos = new Dictionary<SYFrameType, int>();
                    int nPos = 0;
                    SYFrameData frameData = (SYFrameData)Marshal.PtrToStructure(pFrameData, typeof(SYFrameData));
                    for (int nFrameIndex = 0; nFrameIndex < frameData.m_nFrameCount; nFrameIndex++)
                    {
                        IntPtr intPtr = IntPtr.Add(frameData.m_pFrameInfo, nFrameIndex * Marshal.SizeOf(typeof(SYFrameInfo)));
                        SYFrameInfo pFrameInfo = Marshal.PtrToStructure<SYFrameInfo>(intPtr);
                        mapIndex.Add(pFrameInfo.m_frameType,nFrameIndex);
                        mapPos.Add(pFrameInfo.m_frameType,nPos);
                        nPos += pFrameInfo.m_nFrameHeight * pFrameInfo.m_nFrameWidth * sizeof(ushort);
                    }
                    
                    if (mapIndex.TryGetValue(Synexens.SYFrameType.SYFRAMETYPE_DEPTH, out var itDepthIndex) && mapIndex.TryGetValue(Synexens.SYFrameType.SYFRAMETYPE_RGB, out var itRGBIndex))
                    {
                        IntPtr intPtrRgb = IntPtr.Add(frameData.m_pFrameInfo, itRGBIndex * Marshal.SizeOf(typeof(SYFrameInfo)));
                        SYFrameInfo pRgbFrameInfo = Marshal.PtrToStructure<SYFrameInfo>(intPtrRgb);
                        int nRGBDWidth = pRgbFrameInfo.m_nFrameWidth;
                        int nRGBDHeight = pRgbFrameInfo.m_nFrameHeight;

                        IntPtr pRGBDDepth = Marshal.AllocHGlobal(nRGBDWidth * nRGBDHeight * Marshal.SizeOf(typeof(ushort)));
                        IntPtr pRGBDRGB = Marshal.AllocHGlobal(nRGBDWidth * nRGBDHeight * 3);
                        try
                        {
                            IntPtr intPtr = IntPtr.Add(frameData.m_pFrameInfo, itDepthIndex * Marshal.SizeOf(typeof(SYFrameInfo)));
                            SYFrameInfo pFrameInfo = Marshal.PtrToStructure<SYFrameInfo>(intPtr);
                            
                            ushort* ushortPointer = (ushort*)frameData.m_pData.ToPointer();
                            int bb = mapPos[SYFrameType.SYFRAMETYPE_DEPTH];
                            ushortPointer += mapPos[SYFrameType.SYFRAMETYPE_DEPTH];
                            
                            byte* bytePointer = (byte*)frameData.m_pData.ToPointer();
                            bytePointer += mapPos[SYFrameType.SYFRAMETYPE_RGB];
                            
                            if (SYSDKInterface.GetRGBD(nDeviceID, pFrameInfo.m_nFrameWidth, pFrameInfo.m_nFrameHeight, ushortPointer,
                                    nRGBDWidth, nRGBDHeight, bytePointer, nRGBDWidth, nRGBDHeight, pRGBDDepth, pRGBDRGB) == SYErrorCode.SYERRORCODE_SUCCESS)
                            {
                                Mat gray16 = new Mat(nRGBDHeight, nRGBDWidth, MatType.CV_16UC1, pRGBDDepth);
                                int nCount = nRGBDWidth * nRGBDHeight;
                                Mat rgbimg = new Mat(nRGBDHeight, nRGBDWidth, MatType.CV_8UC3);
                                Mat bgrimg = new Mat(nRGBDHeight, nRGBDWidth, MatType.CV_8UC3);
                                byte[] pColor = new byte[nCount * 3];
                                if (SYSDKInterface.GetDepthColor(nDeviceID, nCount, pRGBDDepth, pColor) == SYErrorCode.SYERRORCODE_SUCCESS)
                                {
                                    Marshal.Copy(pColor,0,bgrimg.Data,nCount*3);
                                    Cv2.CvtColor(bgrimg, rgbimg, ColorConversionCodes.BGR2RGB);
                                }
                                else
                                {
                                    Mat tmp = new Mat();
                                    Mat gray8 = new Mat(gray16.Size(), MatType.CV_8U);
                                    Cv2.Normalize(gray16,tmp,0,255,NormTypes.MinMax);
                                    Cv2.ConvertScaleAbs(tmp,gray8);
                                    Cv2.CvtColor(gray8, rgbimg, ColorConversionCodes.GRAY2RGB);
                                }
                                string windowName = $"RGBD_depth_{nDeviceID}";
                                IsImgWindow(windowName, rgbimg);

                                // RGB
                                Mat bgrImgRGB = new Mat(nRGBDHeight, nRGBDWidth, MatType.CV_8UC3, pRGBDRGB);
                                Cv2.CvtColor(bgrImgRGB, rgbimg, ColorConversionCodes.BGR2RGB);
                                
                                windowName = $"RGBD_RGB_{nDeviceID}";
                                IsImgWindow(windowName, rgbimg);
                            }
                        }
                        finally
                        {
                            Marshal.FreeHGlobal(pRGBDDepth);
                            Marshal.FreeHGlobal(pRGBDRGB);
                        }
                    }
                }
                else
                {
                    int nPos = 0;
                    SYFrameData frameData = (SYFrameData)Marshal.PtrToStructure(pFrameData, typeof(SYFrameData));
                    if (frameData.m_pFrameInfo != IntPtr.Zero)
                    {
                     for (int nFrameIndex = 0; nFrameIndex < frameData.m_nFrameCount; nFrameIndex++)
                     {
                         IntPtr intPtr = IntPtr.Add(frameData.m_pFrameInfo, nFrameIndex * Marshal.SizeOf(typeof(SYFrameInfo)));
                         SYFrameInfo pFrameInfo = Marshal.PtrToStructure<SYFrameInfo>(intPtr);
                         switch (pFrameInfo.m_frameType)
                         {
                             case SYFrameType.SYFRAMETYPE_RAW:
                             {
                                 byte* bytePointer = (byte*)frameData.m_pData.ToPointer();
                                 bytePointer += nPos;
                                 IntPtr data = (IntPtr)bytePointer;
                                 Mat gray16 = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_16UC1, data);
                                 Mat tmp = new Mat();
                                 Mat gray8 = new Mat(gray16.Size(), MatType.CV_8U);
                                 Cv2.Normalize(gray16, tmp, 0, 255, NormTypes.MinMax);
                                 Cv2.ConvertScaleAbs(tmp, gray8);
                                 Mat rgbImg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC3);
                                 Cv2.CvtColor(gray8, rgbImg, ColorConversionCodes.GRAY2RGB);
                                 string windowName = $"raw_{nDeviceID}";
                                 IsImgWindow(windowName, rgbImg);
                                 nPos += pFrameInfo.m_nFrameWidth * pFrameInfo.m_nFrameHeight * sizeof(short);
                                 break;
                             } 
                             case SYFrameType.SYFRAMETYPE_DEPTH:
                             { 
                                 int nCount = pFrameInfo.m_nFrameHeight * pFrameInfo.m_nFrameWidth;
                                 byte[] pColor = new byte[nCount * 3];
                                 Mat rgbimg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC3);
                                 Mat bgrimg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC3);
                                 
                                 byte* ushortPointer = (byte*)frameData.m_pData.ToPointer();
                                 ushortPointer += nPos;

                                 if (SYSDKInterface.GetDepthColor(nDeviceID, nCount, (IntPtr)ushortPointer, pColor) == SYErrorCode.SYERRORCODE_SUCCESS)
                                 {
                                     Marshal.Copy(pColor,0,rgbimg.Data,nCount*3);
                                     Cv2.CvtColor(rgbimg, bgrimg, ColorConversionCodes.RGB2BGR);

                                     if (g_mapSavePCL.TryGetValue(nDeviceID, out bool bSavePCL))
                                     {
                                         if (bSavePCL)
                                         {
                                             IntPtr ptrPclData = Marshal.AllocHGlobal(nCount * Marshal.SizeOf(typeof(SYPointCloudData)));
                                             try
                                             {
                                                 if(SYSDKInterface.GetDepthPointCloud(nDeviceID, pFrameInfo.m_nFrameWidth, pFrameInfo.m_nFrameHeight, (IntPtr)ushortPointer, ptrPclData) == SYErrorCode.SYERRORCODE_SUCCESS)
                                                 {
                                                     string filePath = Path.Combine(Directory.GetCurrentDirectory(), "pcldata");
                                                     Directory.CreateDirectory(filePath);

                                                     string fileName = $"{nDeviceID}_PointCloudData_{DateTime.Now.Ticks}.pcd";
                                                     string fullPath = Path.Combine(filePath, fileName);

                                                     using (StreamWriter writer = new StreamWriter(fullPath))
                                                     {
                                                         writer.WriteLine("# .PCD v0.7 - Point Cloud Data file format");
                                                         writer.WriteLine("VERSION 0.7");
                                                         writer.WriteLine("FIELDS x y z rgb");
                                                         writer.WriteLine("SIZE 4 4 4 4");
                                                         writer.WriteLine("TYPE F F F U");
                                                         writer.WriteLine("COUNT 1 1 1 1");
                                                         writer.WriteLine($"WIDTH {nCount}");
                                                         writer.WriteLine("HEIGHT 1");
                                                         writer.WriteLine("VIEWPOINT 0 0 0 1 0 0 0");
                                                         writer.WriteLine($"POINTS {nCount}");
                                                         writer.WriteLine("DATA ascii");
                                                         
                                                         SYPointCloudData* pclData = (SYPointCloudData*)ptrPclData.ToPointer();
                                                         for (int n = 0; n < nCount; n++)
                                                         {
                                                             byte[] cTemp = new byte[4];
                                                             cTemp[1] = pColor[n * 3];
                                                             cTemp[2] = pColor[n * 3 + 1];
                                                             cTemp[3] = pColor[n * 3 + 2];
                                                             uint nTemp = BitConverter.ToUInt32(cTemp, 0);
                                                             
                                                             writer.WriteLine($"{pclData[n].m_fltX} {pclData[n].m_fltY} {pclData[n].m_fltZ} {nTemp}");
                                                         }
                                                     }

                                                     Console.WriteLine($"File saved to: {fullPath}");
                                                     g_mapSavePCL[nDeviceID] = false;
                                                 }
                                             }
                                             finally
                                             {
                                                 Marshal.FreeHGlobal(ptrPclData);
                                             }
                                         }
                                     }
                                 }
                                 else
                                 {
                                     byte* bytePointer = (byte*)frameData.m_pData.ToPointer();
                                     bytePointer += nPos;
                                     IntPtr data = (IntPtr)bytePointer;
                                     Mat gray16 = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_16UC1, data);
                                     
                                     Mat tmp = new Mat();
                                     Mat gray8 = new Mat(gray16.Size(), MatType.CV_8U);
                                     Cv2.Normalize(gray16,tmp,0,255,NormTypes.MinMax);
                                     Cv2.ConvertScaleAbs(tmp,gray8);
                                     Cv2.CvtColor(gray8, rgbimg, ColorConversionCodes.GRAY2RGB);
                                 }
                                 string windowName = $"depth_{nDeviceID}";
                                 IsImgWindow(windowName, bgrimg);
                                 nPos += pFrameInfo.m_nFrameHeight * pFrameInfo.m_nFrameWidth * sizeof(short);
                                 break;
                            }
                             case SYFrameType.SYFRAMETYPE_IR:
                             {
                                byte* ushortPointer = (byte*)frameData.m_pData.ToPointer();
                                ushortPointer += nPos;
                                IntPtr data = (IntPtr)ushortPointer;
                                Mat gray16 = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_16UC1, data);
                                Mat tmp = new Mat();
                                Mat gray8 = new Mat();
                                //Cv2.Normalize(gray16, tmp, 0, 255, NormTypes.MinMax);
                                Cv2.ConvertScaleAbs(gray16, gray8,0.5,0);
                                string windowName = $"ir_{nDeviceID}";
                                IsImgWindow(windowName,gray8);
                                nPos += pFrameInfo.m_nFrameHeight * pFrameInfo.m_nFrameWidth * sizeof(short);
                                break;
                             }
                             case SYFrameType.SYFRAMETYPE_RGB:
                             {
                                 byte* ushortPointer = (byte*)frameData.m_pData.ToPointer();
                                 ushortPointer += nPos;
                                 IntPtr data = (IntPtr)ushortPointer;
                                 Mat yuvImg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC2, data);
                                 Mat rgbImg;
                                 Mat bgrImg;
                                 rgbImg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC3);
                                 bgrImg = new Mat(pFrameInfo.m_nFrameHeight, pFrameInfo.m_nFrameWidth, MatType.CV_8UC3);
                                 Cv2.CvtColor(yuvImg, rgbImg, ColorConversionCodes.YUV2RGB_YUYV);
                                 Cv2.CvtColor(rgbImg, bgrImg, ColorConversionCodes.RGB2BGR);

                                 string name = $"RGB_{nDeviceID}";
                                 IsImgWindow(name, bgrImg);
                                 nPos += pFrameInfo.m_nFrameHeight * pFrameInfo.m_nFrameWidth * 3 / 2;
                                 break;
                             }
                          }
                     }
                    }
                }
            }
        }
        
        public static void PrintErrorCode(string strFunc, SYErrorCode errorCode)
        {
            Console.WriteLine($"{strFunc} errorcode: {errorCode}");
        }
        
        public static unsafe void Main(string[] args)
        {
            Console.WriteLine("SynexensCSharpSDK Test Demo");
            int nSDKVersionLength = 0;

            SYErrorCode errorCodeGetSDKVersion = SYSDKInterface.GetSDKVersion(ref nSDKVersionLength, null);
            if (errorCodeGetSDKVersion == SYErrorCode.SYERRORCODE_SUCCESS)
            {
                if (nSDKVersionLength > 0)
                {
                    StringBuilder versionBuilder = new StringBuilder(nSDKVersionLength);
                    errorCodeGetSDKVersion = Synexens.SYSDKInterface.GetSDKVersion(ref nSDKVersionLength, versionBuilder);
                    if (errorCodeGetSDKVersion == SYErrorCode.SYERRORCODE_SUCCESS)
                    {
                        Console.WriteLine("SDKVersion:" + versionBuilder);
                    }
                    else
                    {
                        PrintErrorCode("GetSDKVersion2", errorCodeGetSDKVersion);
                    }
                }
            }
            else
            {
                PrintErrorCode("GetSDKVersion2",errorCodeGetSDKVersion);
            }
            
            SYErrorCode errorCodeInitSDK = SYSDKInterface.InitSDK();
            if (errorCodeInitSDK != SYErrorCode.SYERRORCODE_SUCCESS)
            {
                PrintErrorCode("InitSDK",errorCodeInitSDK);
            }
            
            int nDeviceCount = 0;
            SYErrorCode errorCode = SYSDKInterface.FindDevice(out nDeviceCount, null);
            if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS && nDeviceCount > 0)
            {
                SYDeviceInfo[] devices = new SYDeviceInfo[nDeviceCount];
                errorCode = SYSDKInterface.FindDevice(out nDeviceCount, devices);
                if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                {
                    bool[] pOpen = new bool[nDeviceCount];
                    Array.Clear(pOpen, 0, pOpen.Length);
                    int[] pIntegralTimeMin = new int[nDeviceCount];
                    int[] pIntegralTimeMax = new int[nDeviceCount];
                    int[] pIntegralTime = new int[nDeviceCount];
                    for (uint i = 0; i < nDeviceCount; i++)
                    {
                        g_mapSavePCL.Add(devices[i].m_nDeviceID, false);
                        g_mapSaveDepthOrRAW.Add(devices[i].m_nDeviceID, false);
                        Console.WriteLine($"Device1 {i + 1}: ID = {devices[i].m_nDeviceID}, Type = {devices[i].m_deviceType}");
                        Thread.Sleep(1000);
                        SYErrorCode errorCodeOpenDevice = Synexens.SYSDKInterface.OpenDevice(ref devices[i]);
                        if (errorCodeOpenDevice == SYErrorCode.SYERRORCODE_SUCCESS)
                        {
                            int nStringLength = 0; 
                            SYErrorCode errorCodeGetSN = SYSDKInterface.GetDeviceSN(devices[i].m_nDeviceID, ref nStringLength, null);
                            if (errorCodeGetSN == SYErrorCode.SYERRORCODE_SUCCESS)
                            {
                                if (nStringLength > 0)
                                {
                                    StringBuilder serialNumerBuilder = new StringBuilder(nStringLength);
                                    errorCodeGetSN = SYSDKInterface.GetDeviceSN(devices[i].m_nDeviceID, ref nStringLength, serialNumerBuilder);
                                    if (errorCodeGetSN == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("SN{0}:{1}", i, serialNumerBuilder);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetDeviceSN", errorCodeGetSN);
                                    }
                                }
                            }
                            
                            nStringLength = 0;
                            SYErrorCode errorCodeGetHWVersion = SYSDKInterface.GetDeviceHWVersion(devices[i].m_nDeviceID, ref nStringLength, null);
                            if (errorCodeGetHWVersion == SYErrorCode.SYERRORCODE_SUCCESS)
                            {
                                if (nStringLength > 0)
                                {
                                    StringBuilder hwversionBuilder = new StringBuilder(nStringLength);
                                    errorCodeGetHWVersion = SYSDKInterface.GetDeviceHWVersion(devices[i].m_nDeviceID, ref nStringLength, hwversionBuilder);
                                    if (errorCodeGetHWVersion == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("HWVersion{0}:{1}", i, hwversionBuilder);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetDeviceHWVersion2", errorCodeGetHWVersion);
                                    }
                                }
                                else
                                {
                                    PrintErrorCode("GetDeviceHWVersion", errorCodeGetHWVersion);
                                }
                            }

                            int nSupportTypeCount = 0;
                            
                            SYSupportType[] supportTypes = null;
                            SYErrorCode errorCodeQueryFrameType = SYSDKInterface.QueryDeviceSupportFrameType(devices[i].m_nDeviceID, ref nSupportTypeCount,null);
                            if (errorCodeQueryFrameType == SYErrorCode.SYERRORCODE_SUCCESS && nSupportTypeCount > 0)
                            {
                                supportTypes = new SYSupportType[nSupportTypeCount];
                                
                                errorCodeQueryFrameType = SYSDKInterface.QueryDeviceSupportFrameType(devices[i].m_nDeviceID, ref nSupportTypeCount, supportTypes);
                                if (errorCodeQueryFrameType == SYErrorCode.SYERRORCODE_SUCCESS && nSupportTypeCount > 0)
                                {
                                    for (int j = 0; j < nSupportTypeCount; j++)
                                    {
                                        Console.WriteLine("FrameType{0}:{1}", j, supportTypes[j]);
                                        int nResolutionCount = 0;

                                        SYResolution[] pResolution = null;
                                        SYErrorCode errorCodeQueryResolution = SYSDKInterface.QueryDeviceSupportResolution(devices[i].m_nDeviceID, supportTypes[j], ref nResolutionCount, null);
                                        if (errorCodeQueryResolution == SYErrorCode.SYERRORCODE_SUCCESS && nResolutionCount > 0)
                                        {
                                            pResolution = new SYResolution[nResolutionCount];
                                            errorCodeQueryResolution = SYSDKInterface.QueryDeviceSupportResolution(devices[i].m_nDeviceID, supportTypes[j], ref nResolutionCount, pResolution);
                                            if (errorCodeQueryResolution == SYErrorCode.SYERRORCODE_SUCCESS && nResolutionCount > 0)
                                            {
                                                for (int k = 0; k < nResolutionCount; k++)
                                                {
                                                    Console.WriteLine("FrameType{0}:{1},Resolution{2}:{3}", j, supportTypes[j], k, pResolution[k]);
                                                }
                                            }
                                            else
                                            {
                                                PrintErrorCode("QueryDeviceSupportResolution2", errorCodeQueryResolution);
                                            }
                                        }
                                        else
                                        {
                                            PrintErrorCode("QueryDeviceSupportResolution", errorCodeQueryResolution);
                                        }
                                    }
                                }
                                else
                                {
                                    PrintErrorCode("QueryDeviceSupportFrameType2", errorCodeQueryFrameType);
                                }
                            }
                            else
                            {
                                PrintErrorCode("QueryDeviceSupportFrameType", errorCodeQueryFrameType);
                            }

                            switch (devices[i].m_deviceType)
                            {
                                case SYDeviceType.SYDEVICETYPE_CS20_SINGLE:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_320_240);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        SYStreamType streamType = SYStreamType.SYSTREAMTYPE_DEPTHIR;
                                        errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                            {
                                                g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                            }
                                            else
                                            {
                                                g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                            }

                                            pOpen[i] = true;
                                            CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                        }
                                        else
                                        {
                                            PrintErrorCode("StartStreaming", errorCode);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth", errorCode);
                                    }
                                } break;
                                case SYDeviceType.SYDEVICETYPE_CS20_DUAL:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_320_240);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        SYStreamType streamType = SYStreamType.SYSTREAMTYPE_DEPTHIR;
                                        errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                            {
                                                g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                            }
                                            else
                                            {
                                                g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                            }
                                            pOpen[i] = true;
                                            CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                        }
                                        else
                                        {
                                            PrintErrorCode("StartStreaming", errorCode);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth", errorCode);
                                    }
                                }break;
                                case SYDeviceType.SYDEVICETYPE_CS20_P:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_320_240);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        SYStreamType streamType = SYStreamType.SYSTREAMTYPE_DEPTH;
                                        errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                            {
                                                g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                            }
                                            else
                                            {
                                                g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                            }
                                            pOpen[i] = true;
                                            CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth", errorCode);
                                    }
                                }break;
                                case SYDeviceType.SYDEVICETYPE_CS30_SINGLE:
                                case SYDeviceType.SYDEVICETYPE_CS30_DUAL:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_640_480);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_RGB, SYResolution.SYRESOLUTION_1920_1080);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            SYStreamType streamType = SYStreamType.SYSTREAMTYPE_DEPTH;
                                            errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                            if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                            {
                                                if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                                {
                                                    g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                                }
                                                else
                                                {
                                                    g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                                }
                                                pOpen[i] = true;
                                                CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                            }
                                        }
                                        else
                                        {
                                            PrintErrorCode("SetFrameResolution RGB", errorCode);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth",errorCode);
                                    }
                                } break;
                                case SYDeviceType.SYDEVICETYPE_CS40:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_640_480);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        SYStreamType streamType = SYStreamType.SYSTREAMTYPE_DEPTH;
                                        errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                            {
                                                g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                            }
                                            else
                                            {
                                                g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                            }
                                            pOpen[i] = true;
                                            CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                        }
                                        else
                                        {
                                            PrintErrorCode("StartStreaming", errorCode);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth", errorCode);
                                    }
                                }break;
                                case SYDeviceType.SYDEVICETYPE_CS40PRO:
                                {
                                    errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID,SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_640_480);
                                    if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        errorCode = SYSDKInterface.SetFrameResolution(devices[i].m_nDeviceID, SYFrameType.SYFRAMETYPE_RGB, SYResolution.SYRESOLUTION_1600_1200);
                                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            SYStreamType streamType = SYStreamType.SYSTREAMTYPE_RGBD;
                                            errorCode = SYSDKInterface.StartStreaming(devices[i].m_nDeviceID, streamType);
                                            if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                                            {
                                                if (g_mapStreamType.TryGetValue(devices[i].m_nDeviceID, out Synexens.SYStreamType existingStreamType))
                                                {
                                                    g_mapStreamType[devices[i].m_nDeviceID] = streamType;
                                                }
                                                else
                                                {
                                                    g_mapStreamType.Add(devices[i].m_nDeviceID, streamType);
                                                }
                                                pOpen[i] = true;
                                                CreateOpencvWindow(devices[i].m_nDeviceID, streamType);
                                            }
                                            else
                                            {
                                                PrintErrorCode("StartStreaming", errorCode);
                                            }
                                        }
                                        else
                                        {
                                            PrintErrorCode("SetFrameResolution Rgb", errorCode);
                                        }
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFrameResolution Depth", errorCode);
                                    }
                                }break;
                            }
                        }
                        else
                        {
                            PrintErrorCode("OpenDevice",errorCodeOpenDevice);
                        }
                    } 
                    
                    while (true)
                    {
                        for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                        {
                            if (pOpen[nDeviceIndex])
                            {
                                IntPtr pFrameDataPtr = IntPtr.Zero;
                                SYErrorCode errorCodeLastFrame = SYSDKInterface.GetLastFrameData(devices[nDeviceIndex].m_nDeviceID, ref pFrameDataPtr);
                                if (errorCodeLastFrame == SYErrorCode.SYERRORCODE_SUCCESS)
                                {
                                    ProcessFrameData(devices[nDeviceIndex].m_nDeviceID, pFrameDataPtr);
                                }
                                else
                                {
                                    //PrintErrorCode("GetLastFrameData", errorCode);
                                }
                            }
                        }

                        bool bBreak = false;
 
                        switch (Cv2.WaitKey(30))
                        {
                            case 27: //ESC
                            {
                                bBreak = true;
                                Cv2.DestroyAllWindows();
                                break;
                            }
                            case 76: //L Switch to low resolution.
                                {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                    {
                                        switch (devices[nDeviceIndex].m_deviceType)
                                        {
                                            case SYDeviceType.SYDEVICETYPE_CS30_SINGLE:
                                            case SYDeviceType.SYDEVICETYPE_CS30_DUAL:
                                                {
                                                    if (g_mapStreamType.TryGetValue(devices[nDeviceIndex].m_nDeviceID, out Synexens.SYStreamType streamType))
                                                    {
                                                        if (g_mapStreamType[devices[nDeviceIndex].m_nDeviceID] != SYStreamType.SYSTREAMTYPE_RGBD)
                                                        {
                                                            SYErrorCode errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_320_240);
                                                            if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                            {
                                                                PrintErrorCode("SetFrameResolution Depth", errorCodeChangeResolution);
                                                            }
                                                            errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_RGB, SYResolution.SYRESOLUTION_640_480);
                                                            if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                            {
                                                                PrintErrorCode("SetFrameResolution RGB", errorCodeChangeResolution);
                                                            }

                                                            errorCodeChangeResolution = SYSDKInterface.ChangeStreaming(devices[nDeviceIndex].m_nDeviceID, g_mapStreamType[devices[nDeviceIndex].m_nDeviceID]);
                                                            if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                            {
                                                                PrintErrorCode("ChangeFrameResolution ChangeStreaming", errorCodeChangeResolution);
                                                            }
                                                        }
                                                    }
                                                    break;
                                                }
                                            case SYDeviceType.SYDEVICETYPE_CS20_DUAL:
                                                {
                                                    if (g_mapStreamType.TryGetValue(devices[nDeviceIndex].m_nDeviceID, out Synexens.SYStreamType streamType))
                                                    {
                                                        SYErrorCode errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_320_240);
                                                        if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                        {
                                                            PrintErrorCode("SetFrameResolution Depth", errorCodeChangeResolution);
                                                        }
                                                        errorCodeChangeResolution = SYSDKInterface.ChangeStreaming(devices[nDeviceIndex].m_nDeviceID, g_mapStreamType[devices[nDeviceIndex].m_nDeviceID]);
                                                        if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                        {
                                                            PrintErrorCode("ChangeFrameResolution ChangeStreaming", errorCodeChangeResolution);
                                                        }
                                                    }
                                                    break;
                                                }
                                        }
                                    }
                                    break;
                            }
                            case 72: //H Switch to high resolution.
                                {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    switch (devices[nDeviceIndex].m_deviceType)
                                    {
                                        case SYDeviceType.SYDEVICETYPE_CS30_SINGLE:
                                        case SYDeviceType.SYDEVICETYPE_CS30_DUAL:
                                            {
                                                if (g_mapStreamType.TryGetValue(devices[nDeviceIndex].m_nDeviceID, out Synexens.SYStreamType streamType))
                                                {
                                                    if (g_mapStreamType[devices[nDeviceIndex].m_nDeviceID] != SYStreamType.SYSTREAMTYPE_RGBD)
                                                    {
                                                        SYErrorCode errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_640_480);
                                                        if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                        {
                                                            PrintErrorCode("SetFrameResolution Depth High", errorCodeChangeResolution);
                                                        }
                                                        errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_RGB, SYResolution.SYRESOLUTION_1920_1080);
                                                        if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                        {
                                                            PrintErrorCode("SetFrameResolution RGB High", errorCodeChangeResolution);
                                                        }
                                                        errorCodeChangeResolution = SYSDKInterface.ChangeStreaming(devices[nDeviceIndex].m_nDeviceID, g_mapStreamType[devices[nDeviceIndex].m_nDeviceID]);
                                                        if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                        {
                                                            PrintErrorCode("ChangeFrameResolution ChangeStreaming", errorCodeChangeResolution);
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        case SYDeviceType.SYDEVICETYPE_CS20_DUAL:
                                            {
                                                if (g_mapStreamType.TryGetValue(devices[nDeviceIndex].m_nDeviceID, out Synexens.SYStreamType streamType))
                                                {
                                                    SYErrorCode errorCodeChangeResolution = SYSDKInterface.SetFrameResolution(devices[nDeviceIndex].m_nDeviceID, SYFrameType.SYFRAMETYPE_DEPTH, SYResolution.SYRESOLUTION_640_480);
                                                    if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                    {
                                                        PrintErrorCode("SetFrameResolution Depth High", errorCodeChangeResolution);
                                                    }
                                                    errorCodeChangeResolution = SYSDKInterface.ChangeStreaming(devices[nDeviceIndex].m_nDeviceID, g_mapStreamType[devices[nDeviceIndex].m_nDeviceID]);
                                                    if (errorCodeChangeResolution != SYErrorCode.SYERRORCODE_SUCCESS)
                                                    {
                                                        PrintErrorCode("ChangeFrameResolution ChangeStreaming", errorCodeChangeResolution);
                                                    }
                                                }
                                                break;
                                            }
                                    }
                                }
                                break;
                            }
                            case 85: //U Increase the integration time.
                                {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    SYErrorCode errorCodeIntegralTime = SYSDKInterface.GetIntegralTimeRange(devices[nDeviceIndex].m_nDeviceID, SYResolution.SYRESOLUTION_640_480, ref pIntegralTimeMin[nDeviceIndex], ref pIntegralTimeMax[nDeviceIndex]);
                                    if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetIntegralTimeRange success, IntegralTimeMin:" + pIntegralTimeMin[nDeviceIndex] + " IntegralTimeMax:" + pIntegralTimeMax[nDeviceIndex]);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetIntegralTimeRange", errorCodeIntegralTime);
                                    }
                                    errorCodeIntegralTime = SYSDKInterface.GetIntegralTime(devices[nDeviceIndex].m_nDeviceID, ref pIntegralTime[nDeviceIndex]);
                                    if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetIntegralTime success, IntegralTime:" + pIntegralTime[nDeviceIndex]);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetIntegralTime", errorCodeIntegralTime);
                                    }

                                    if (pIntegralTime[nDeviceIndex] >= pIntegralTimeMax[nDeviceIndex])
                                    {
                                        Console.WriteLine("IntegralTime already be Max");
                                    }
                                    else
                                    {
                                        pIntegralTime[nDeviceIndex] += 100;
                                        if (pIntegralTime[nDeviceIndex] >= pIntegralTimeMax[nDeviceIndex])
                                            pIntegralTime[nDeviceIndex] = pIntegralTimeMax[nDeviceIndex];
                                        errorCodeIntegralTime = SYSDKInterface.SetIntegralTime(devices[nDeviceIndex].m_nDeviceID, pIntegralTime[nDeviceIndex]);
                                        if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            Console.WriteLine("SetIntegralTime success, IntegralTime:" + pIntegralTime[nDeviceIndex]);
                                        }
                                        else
                                        {
                                            PrintErrorCode("SetIntegralTime", errorCodeIntegralTime);
                                        }
                                    }
                                }
                                break;
                            }
                            case 68: //D Decrease the integration time.
                                {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    SYErrorCode errorCodeIntegralTime = SYSDKInterface.GetIntegralTimeRange(devices[nDeviceIndex].m_nDeviceID, SYResolution.SYRESOLUTION_640_480, ref pIntegralTimeMin[nDeviceIndex], ref pIntegralTimeMax[nDeviceIndex]);
                                    if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetIntegralTimeRange success, IntegralTimeMin:" + pIntegralTimeMin[nDeviceIndex] + " IntegralTimeMax:" + pIntegralTimeMax[nDeviceIndex]);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetIntegralTimeRange", errorCodeIntegralTime);
                                    }
                                    errorCodeIntegralTime = SYSDKInterface.GetIntegralTime(devices[nDeviceIndex].m_nDeviceID, ref pIntegralTime[nDeviceIndex]);
                                    if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetIntegralTime success, IntegralTime:" + pIntegralTime[nDeviceIndex]);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetIntegralTime", errorCodeIntegralTime);
                                    }
                                    if (pIntegralTime[nDeviceIndex] <= pIntegralTimeMin[nDeviceIndex])
                                    {
                                        Console.WriteLine("IntegralTime already be Min");
                                    }
                                    else
                                    {
                                        pIntegralTime[nDeviceIndex] -= 100;
                                        if (pIntegralTime[nDeviceIndex] <= pIntegralTimeMin[nDeviceIndex])
                                            pIntegralTime[nDeviceIndex] = pIntegralTimeMin[nDeviceIndex];
                                        errorCodeIntegralTime = SYSDKInterface.SetIntegralTime(devices[nDeviceIndex].m_nDeviceID, pIntegralTime[nDeviceIndex]);
                                        if (errorCodeIntegralTime == SYErrorCode.SYERRORCODE_SUCCESS)
                                        {
                                            Console.WriteLine("SetIntegralTime success, IntegralTime:" + pIntegralTime[nDeviceIndex]);
                                        }
                                        else
                                        {
                                            PrintErrorCode("SetIntegralTime", errorCodeIntegralTime);
                                        }
                                    }
                                }
                                break;
                            }
                            case 70: //F Turn on or turn off filtering.
                                {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    bool bFilter = false;
                                    SYErrorCode errorCodeFilter = SYSDKInterface.GetFilter(devices[nDeviceIndex].m_nDeviceID, ref bFilter);
                                    if (errorCodeFilter == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetFilter success, Filter:" + bFilter);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetFilter", errorCodeFilter);
                                    }
                                    bFilter = !bFilter;
                                    errorCodeFilter = SYSDKInterface.SetFilter(devices[nDeviceIndex].m_nDeviceID, bFilter);
                                    if (errorCodeFilter == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("SetFilter success, Filter:" + bFilter);
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFilter", errorCodeFilter);
                                    }
                                }
                                break;
                            }
                            case 77: //M Mirror Image
                            {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    bool bMirror = false;
                                    SYErrorCode errorCodeMirror = SYSDKInterface.GetMirror(devices[nDeviceIndex].m_nDeviceID, ref bMirror);
                                    if (errorCodeMirror == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetMirror success, Mirror:" + bMirror);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetMirror", errorCodeMirror);
                                    }
                                    bMirror = !bMirror;
                                    errorCodeMirror = SYSDKInterface.SetMirror(devices[nDeviceIndex].m_nDeviceID, bMirror);
                                    if (errorCodeMirror == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("SetMirror success, Mirror:" + bMirror);
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetMirror", errorCodeMirror);
                                    }
                                }
                                break;
                            }
                            case 73: //I Flip Image
                            {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    bool bFlip = false;
                                    SYErrorCode errorCodeFlip = SYSDKInterface.GetFlip(devices[nDeviceIndex].m_nDeviceID, ref bFlip);
                                    if (errorCodeFlip == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("GetFlip success, Flip:" + bFlip);
                                    }
                                    else
                                    {
                                        PrintErrorCode("GetFlip", errorCodeFlip);
                                    }
                                    bFlip = !bFlip;
                                    errorCodeFlip = SYSDKInterface.SetFlip(devices[nDeviceIndex].m_nDeviceID, bFlip);
                                    if (errorCodeFlip == SYErrorCode.SYERRORCODE_SUCCESS)
                                    {
                                        Console.WriteLine("SetFlip success, Flip:" + bFlip);
                                    }
                                    else
                                    {
                                        PrintErrorCode("SetFlip", errorCodeFlip);
                                    }
                                }
                                break;
                            }
                            case 80: //P Save PointCloud Data
                            {
                                for (int nDeviceIndex = 0; nDeviceIndex < nDeviceCount; nDeviceIndex++)
                                {
                                    if (g_mapSavePCL.TryGetValue(devices[nDeviceIndex].m_nDeviceID, out bool bSavePCL))
                                    {
                                        g_mapSavePCL[devices[nDeviceIndex].m_nDeviceID] = true;
                                    }
                                }
                                break;
                            }
                        }
                        if (bBreak)
                            break;
                    }
                    
                    for (int i = 0; i < nDeviceCount; i++)
                    {
                        if (pOpen[i])
                            errorCode = SYSDKInterface.StopStreaming(devices[i].m_nDeviceID);
                        if (errorCode == SYErrorCode.SYERRORCODE_SUCCESS)
                        {
                            Console.WriteLine("StopStreaming Success");
                        }
                        else
                        {
                            PrintErrorCode("StopStreaming", errorCode);
                        }
                    }
                }
                else
                {
                    PrintErrorCode("FindDevice2", errorCode);
                }
            }
            else
            {
                PrintErrorCode("FindDevice", errorCode);
            }

            errorCodeInitSDK = SYSDKInterface.UnInitSDK();
            if (errorCodeInitSDK != SYErrorCode.SYERRORCODE_SUCCESS)
            {
                PrintErrorCode("UnInitSDK", errorCodeInitSDK);
            }
        }
    }
}