﻿using System;
using System.Runtime.InteropServices;
using System.Security.AccessControl;
using System.Text;

namespace Synexens
{
    public static class SYSDKInterface
    {
        private const string SYSDK_DLL = "SynexensSDK.dll";     

        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetSDKVersion(ref int nLength, StringBuilder strSDKVersion);

        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode InitSDK();

        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode IInitSDKSelectDevices(ref SYDeviceType pDeviceTyeps, int nLen);

        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode UnInitSDK();

        //@ param [in/out] nCount
        //@ param [in/out] pDevice Device information, externally allocated memory, pDevice only retrieves nCount when passed into nulliptr)
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode FindDevice(out int nCount, [In, Out] SYDeviceInfo[] pDevice);

        //@ param [in] deviceInfo
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode OpenDevice(ref SYDeviceInfo deviceInfo);

        //@ param [in] nDeviceID
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode CloseDevice(uint nDeviceID);

        //Query the frame types supported by the device.
        //@ param [in] nDeviceID
        //@ param [in/out]
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode QueryDeviceSupportFrameType(uint nDeviceID, ref int nCount, [In, Out] SYSupportType[] pSupportType);

        //Query the frame resolutions supported by the device.
        //@ param [in] nDeviceID
        //@ param [in/out] sdkSupportType
        //@ param [in/out] resolutionList
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode QueryDeviceSupportResolution(uint nDeviceID, SYSupportType supportType, ref int nCount, SYResolution[] pResolution);

        //Get the current stream type.
        //@ param [in] nDeviceID
        //@ return streamType
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYStreamType GetCurrentStreamType(uint nDeviceID);

        //@ param [in] nDeviceID
        //@ param [in] streamType
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode StartStreaming(uint nDeviceID, SYStreamType streamType);

        //@ param [in] nDeviceID
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode StopStreaming(uint nDeviceID);

        //@ param [in] nDeviceID
        //@ param [in] streamType
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode ChangeStreaming(uint nDeviceID, SYStreamType streamType);

        //Set resolution (if the data stream has already been started, the internal process will follow the steps of closing the stream ->setting resolution ->reopening the stream)
        //@ param [in] nDeviceID
        //@ param [in] frameType
        //@ param [in] resolution
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetFrameResolution(uint nDeviceID, SYFrameType frameType, SYResolution resolution);

        //Get the device frame resolution.
        //@ param [in] nDeviceID
        //@ param [in] frameType
        //@ param [out] resolution
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFrameResolution(uint nDeviceID, SYFrameType frameType, ref SYResolution resolution);

        //Get the filter enabled status.
        //@ param [in] nDeviceID
        //@ param [out] bFilter
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFilter(uint nDeviceID, ref bool bFilter);

        //open or close filter switch
        //@ param [in] nDeviceID
        //@ param [in] bFilter
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetFilter(uint nDeviceID, bool bFilter);

        //Get the hardware filter mode enabled status.
        //@ param [in] nDeviceID
        //@ param [out] bHardWareFilterMode:Hardware filter mode enabled status: true – hardware filter mode enabled; false – hardware filter mode disabled.
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetHardWareFilterMode(uint nDeviceID, ref bool bHardwareFilterMode);

        //Enable/disable hardware filter mode.
        //@ param [in] nDeviceID
        //@ param [in] bHardWareFilterMode:Hardware filter mode enabled status: true – hardware filter mode enabled; false – hardware filter mode disabled.
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetHardWareFilterMode(uint nDeviceID, bool bHardwareFilterMode);

        //Is hardware filter mode available
        //@ param [in] nDeviceID
        //@ param [out] bHaveHardwareFilterMode:Hardware filter mode availability flag，true-available ，false-disbable
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode HaveHardWareFilterMode(uint nDeviceID, ref bool bHardwareFilterMode);

        //Get the list of filters.
        //@ param [in] nDeviceID
        //@ param [in/out] nCount
        //@ param [in/out] pFilterType
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFilterList(uint nDeviceID, ref int nCount, SYFilterType[] pFilterType);

        //Set the default filter.
        //@ param [in] nDeviceID
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetDefaultFilter(uint nDeviceID);

        //param [in] nDeviceID
        //param [in] filterType
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode AddFilter(uint nDeviceID, SYFilterType filterType);

        //@ param [in] nDeviceID
        //@ param [in] nIndex
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode DeleteFilter(uint nDeviceID, int nIndex);

        //@ param [in] nDeviceID
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode ClearFilter(uint nDeviceID);

        //@ param [in] nDeviceID
        //@ param [in] filterType
        //@ param [in] nParamCount
        //@ param [in] pFilterParam
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetFilterParam(uint nDeviceID, SYFilterType filterType, int nParamCount, IntPtr pFilterParam);

        //@ param [in] nDeviceID
        //@ param [in] filterType
        //@ param [in/out] nParamCount
        //@ param [in/out] pFilterParam
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFilterParam(uint nDeviceID, SYFilterType filterType, ref int nParamCount, IntPtr pFilterParam);

        //@ param [in] nDeviceID
        //@ param [out] bMirror
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetMirror(uint nDeviceID, ref bool bMirror);

        //@ param [in] nDeviceID
        //@ param [in] bMirror
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetMirror(uint nDeviceID, bool bMirror);

        //@ param [in] nDeviceID
        //@ param [out] bFlip
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFlip(uint nDeviceID, ref bool bFlip);

        //@ param [in] nDeviceID
        //@ param [in] bFlip
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetFlip(uint nDeviceID, bool bFlip);

        //@ param [in] nDeviceID
        //@ param [out] nIntegralTime
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetIntegralTime(uint nDeviceID, ref int nIntegralTime);

        //@ param [in] nDeviceID
        //@ param [in] nIntegralTime
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetIntegralTime(uint nDeviceID, int nIntegralTime);

        //@ param [in] nDeviceID
        //@ param [in] depthResolution
        //@ param [out] nMin
        //@ param [out] nMax
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetIntegralTimeRange(uint nDeviceID, SYResolution depthResolution, ref int nMin, ref int nMax);

        //Obtain the ranging range
        //param [in] nDeviceID
        //param [out] nMin
        //param [out] nMax
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetDistanceMeasureRange(uint nDeviceID, ref int nMin, ref int nMax);

        //Obtain the user's distance measurement range
        //param [in] nDeviceID
        //param [out] nMin
        //param [out] nMax
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetDistanceUserRange(uint nDeviceID, ref int nMin, ref int nMax);

        //Set user ranging range
        //param [in] nDeviceID
        //param [in] nMin
        //param [in] nMax
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetDistanceUserRange(uint nDeviceID, int nMin, int nMax);

        //Read device SN number
        //param [in] nDeviceID
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetDeviceSN(uint nDeviceID, ref int nLength, StringBuilder strSN);

        //Write device SN number
        //param [in] nDeviceID
        //param [in] pstrSN
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetDeviceSN(uint nDeviceID, int nLength, string pstrSN);

        //Read the firmware version number of the device
        //param [in] nDeviceID
        //return Device firmware version
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetDeviceHWVersion(uint nDeviceID, ref int nLength, StringBuilder strHWVersion);

        //Obtain pseudo color corresponding to depth
        //param [in] nDeviceID
        //param [in] nCount Data volume (pDepth requires nCount * 2 bytes for memory space, pColor requires nCount * 3 bytes)
        //param [in] pDepth
        //param [in/out] pColor
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetDepthColor(uint nDeviceID, int nCount, IntPtr pDepth, byte[] pColor);

        //Obtain depth corresponding point cloud data
        //param [in] nDeviceID
        //param [in] nWidth
        //param [in] nHeight
        //param [in] pDepth
        //param [in/out] pPointCloud Depth corresponds to point cloud data, with external memory allocation
        //param [in] bUndistort
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern unsafe SYErrorCode GetDepthPointCloud(uint nDeviceID, int nWidth, int nHeight, IntPtr pDepth, IntPtr pPointCloud, bool bUndistort = false);

        //param [in] nDeviceID
        //param [in] nSourceDepthWidth
        //param [in] nSourceDepthHeight
        //param [in] pSourceDepth
        //param [in] nSourceRGBWidth
        //param [in] nSourceRGBHeight
        //param [in] pSourceRGB
        //param [in] nTargetWidth
        //param [in] nTargetHeight
        //param [in/out] pTargetDepth The depth data in RGBD is allocated memory externally and has the same length as the source RGB data
        //param [in/out] pTargetRGB The RGB data in RGBD is allocated memory externally and has the same length as the source RGB data
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern unsafe SYErrorCode GetRGBD(uint nDeviceID, int nSourceDepthWidth, int nSourceDepthHeight, ushort* pSourceDepth, int nSourceRGBWidth, int nSourceRGBHeight,  byte* pSourceRGB, int nTargetWidth, int nTargetHeight,  IntPtr pTargetDepth,  IntPtr pTargetRGB, bool bTOFtoRGB = true);

        //Get the latest frame of data
        //param [in] nDeviceID
        //param [in/out] pFrameData
        //return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetLastFrameData(uint nDeviceID, ref IntPtr pFrameData);

        //Remove distortion
        //param [in] nDeviceID
        //param [in] pSource  Distorted data pointer to be removed
        //param [in] nWidth
        //param [in] nHeight
        //param [in] bDepth
        //param [out] pTarget  Distortion removal result data pointer, externally allocated memory, data length consistent with the length of the data pointer to be distorted
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern unsafe SYErrorCode Undistort(uint nDeviceID, ushort* pSource, int nWidth, int nHeight, bool bDepth, IntPtr pTarget);

        //Get camera parameters
        //@ param [in] nDeviceID
        //@ param [in] resolution
        //@ param [in/out] intrinsics
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetIntric(uint nDeviceID, SYResolution resolution, bool bRGB, ref SYIntrinsics intrinsics);

        //Get the status of the drag filter enabled
        //@param[in] nDeviceID
        //@param[out] bFilter
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetTrailFilter(uint nDeviceID, ref bool bFilter);

        //Set the drag filter on status
        //@param[in] nDeviceID
        //@param[in] bFilter
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetTrailFilter(uint nDeviceID, bool bFilter);

        // Modify device IP
        //@ param [in] nDeviceID
        //@ param [in] nIP
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode ChangeDeviceIP(uint nDeviceID, uint nIP);

        // Filter depth data using IR
        //@ param [in] nDeviceID
        //@ param [in/out] pDepth
        //@ param [in] pIR
        //@ param [in] nWidth
        //@ param [in] nHeight
        //@ param [in] nThreshold  Filter parameter array  Maximum 10 data points
        //@ return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode IRFilter(uint nDeviceID, IntPtr pDepth, IntPtr pIR, int nWidth, int nHeight, int nThreshold);

        //SetFrameRate
        //@param[in] nDeviceID
        //@param[in/out] frameRate
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetFrameRate(uint nDeviceID, uint nFrameRate);

        //GetFrameRate
        //@param[in] nDeviceID
        //@param[in/out] frameRate
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetFrameRate(uint nDeviceID, ref uint nFrameRate);

        //GetTemperature
        //@param[in] nDeviceID
        //@param[in/out] temperature
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetTemperature(uint nDeviceID, ref float fTemperature);

        //Check if the frame rate is adjustable.
        //@param[in] nDeviceID
        //@param[in/out] Frame Rate Adjustability Indicator
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode IsFrameRateEnabled(uint nDeviceID, ref bool bEnabled);

        //Parse the configuration file
        //@param[in] Length of the path string
        //@param[in] Full path of the configuration file
        //@param[in/out] Configuration data
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode ParseConfiguration(uint nDeviceID, string pFileName, ref SYConfiguration configuration);

        //Open the stream using the configuration.
        //@param[in] nDeviceID
        //@param[in] Configuration data
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode StartStreamingWithConfiguration(uint nDeviceID, ref SYConfiguration configuration);

        //Export the configuration file
        //@param[in] nDeviceID
        //@param[in] Length of the path string
        //@param[in] Full path of the configuration file
        //@return errorCode
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode ExportConfiguration(uint nDeviceID, int nStringLength, StringBuilder pFileName);


        //Set trigger mode
        //@ param [in] nDeviceID
        //@ param [in] SYTriggerMode 触发模式
        //@ return 错误码
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetTriggerMode(uint nDeviceID, SYTriggerMode triggerMode);

        //Get trigger mode
        //@ param [in] nDeviceID
        //@ param [in/out] SYTriggerMode 触发模式
        //@ return 错误码
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetTriggerMode(uint nDeviceID, ref SYTriggerMode triggerMode);

        //Send software trigger signal
        //@ param [in] nDeviceID
        //@ return 错误码
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SendTriggerSignal(uint nDeviceID);

        //设置同步模式
        //@ param [in] syncMode 同步模式
        //@ param [in] nNTPServerIP NTP服务器IP(小端模式：如192.168.1.110 数据为0x6E01A8C0）
        //@ return 错误码
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode SetSyncMode(SYSyncMode syncMode, uint nNTPServerIP);

        //获取同步模式
        //@ param [in] syncMode 同步模式
        //@ return 错误码
        [DllImport(SYSDK_DLL, CallingConvention = CallingConvention.Cdecl)]
        public static extern SYErrorCode GetSyncMode(ref SYSyncMode syncMode);
    }
}